/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.DodgeAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.EntityUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Dodge
extends Action {
    public static final int MAX_COOL_DOWN_TICK = 10;
    private DodgeDirection dodgeDirection = null;
    private int coolTime = 0;
    private int successivelyCount = 0;
    private int successivelyCoolTick = 0;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (this.successivelyCoolTick > 0) {
            --this.successivelyCoolTick;
        } else {
            this.successivelyCount = 0;
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean enabledDoubleTap = (Boolean)ParCoolConfig.CONFIG_CLIENT.disableDoubleTappingForDodge.get() == false;
        DodgeDirection direction = null;
        if (enabledDoubleTap) {
            if (KeyRecorder.keyBack.isDoubleTapped()) {
                direction = DodgeDirection.Back;
            }
            if (KeyRecorder.keyLeft.isDoubleTapped()) {
                direction = DodgeDirection.Left;
            }
            if (KeyRecorder.keyRight.isDoubleTapped()) {
                direction = DodgeDirection.Right;
            }
        }
        if (direction == null && KeyRecorder.keyDodge.isPressed()) {
            if (KeyBindings.getKeyBack().m_90857_()) {
                direction = DodgeDirection.Back;
            }
            if (KeyBindings.getKeyForward().m_90857_()) {
                direction = DodgeDirection.Front;
            }
            if (KeyBindings.getKeyLeft().m_90857_()) {
                direction = DodgeDirection.Left;
            }
            if (KeyBindings.getKeyRight().m_90857_()) {
                direction = DodgeDirection.Right;
            }
        }
        if (direction == null) {
            return false;
        }
        startInfo.putInt(direction.getCode());
        return parkourability.getActionInfo().can(Dodge.class) && !this.isInSuccessiveCoolDown() && this.coolTime <= 0 && player.m_20096_() && !player.m_6144_() && !stamina.isExhausted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !parkourability.get(Roll.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && !player.m_20096_() && !player.m_20072_() && !player.m_21255_() && !player.m_150110_().f_35935_ && parkourability.getActionInfo().can(Dodge.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.dodgeDirection = DodgeDirection.getFromCode(startData.getInt());
        Vec3 lookVec = player.m_20154_();
        lookVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        double jump = 0.3;
        Vec3 dodgeVec = Vec3.f_82478_;
        switch (this.dodgeDirection) {
            case Front: {
                dodgeVec = lookVec;
                break;
            }
            case Back: {
                dodgeVec = lookVec.m_82548_();
                break;
            }
            case Right: {
                dodgeVec = lookVec.m_82524_(-1.5707964f);
                break;
            }
            case Left: {
                dodgeVec = lookVec.m_82524_(1.5707964f);
            }
        }
        this.coolTime = 10;
        if (this.successivelyCount < 3) {
            ++this.successivelyCount;
        }
        this.successivelyCoolTick = 30;
        dodgeVec = dodgeVec.m_82490_(0.6 * (Double)ParCoolConfig.CONFIG_CLIENT.dodgeSpeedModifier.get());
        EntityUtil.addVelocity((Entity)player, new Vec3(dodgeVec.f_82479_, 0.3, dodgeVec.f_82481_));
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DodgeAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.dodgeDirection = DodgeDirection.getFromCode(startData.getInt());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DodgeAnimator());
        }
    }

    public DodgeDirection getDodgeDirection() {
        return this.dodgeDirection;
    }

    public int getCoolTime() {
        return this.coolTime;
    }

    public int getSuccessivelyCoolTick() {
        return this.successivelyCoolTick;
    }

    public boolean isInSuccessiveCoolDown() {
        return this.successivelyCount >= 3;
    }

    public float getCoolDownPhase() {
        return Math.min((float)(10 - this.getCoolTime()) / 10.0f, this.isInSuccessiveCoolDown() ? (float)(30 - this.getSuccessivelyCoolTick()) / 30.0f : 1.0f);
    }

    public static enum DodgeDirection {
        Front,
        Back,
        Left,
        Right;


        int getCode() {
            switch (this) {
                case Front: {
                    return 0;
                }
                case Back: {
                    return 1;
                }
                case Left: {
                    return 2;
                }
                case Right: {
                    return 3;
                }
            }
            return -1;
        }

        public static DodgeDirection getFromCode(int code) {
            switch (code) {
                case 1: {
                    return Back;
                }
                case 2: {
                    return Left;
                }
                case 3: {
                    return Right;
                }
            }
            return Front;
        }
    }
}

